/*
 *	3d engine in 2d Canvas	- 20060413 - Mathieu 'p01' HENRI
 */

Object.prototype.dumpProperties = function( recurse, level )
{
	var level = level||'\n'
	var dumpOutput = ''
	for( var key in this )
	{
		var type = typeof(this[key])
		if( type!='function' )
			dumpOutput += level+ key +'\t('+type+')\t= '+ ((type=='object' && recurse)?level+'{'+this[key].dumpProperties(true,level+'\t')+level+'}':this[key])
	}
	return dumpOutput
}

if( typeof(opera)=='undefined' )
	opera = new function(){ this.postError = function(){ /*	duh! */ } }



/*
 *	game singleton
 */
var game = new function()
{
	gameSelf	= this;
	this.models = {}

	this.keyUpArray		= []
	this.keyDownArray	= []

	this.navigationMode = 0


	/*
	 *	initialize
	 */
	this.initialize = function( startAnimation )
	{
		this.canvas	= document.getElementById('renderArea');
		this.context2d		= this.canvas.getContext('2d');

		this.boardHandle = document.getElementById('board')

		this.renderCenterX	= .5*this.canvas.width
		this.renderCenterY	= .5*this.canvas.height
		this.fovAngle		= Math.PI/6
		this.fovRatio		= this.renderCenterX / Math.tan( this.fovAngle )


		// keyboard
		for( var i=0;i<256;i++ )
		{
			this.keyUpArray[	i]=0
			this.keyDownArray[	i]=0
		}

		document.onkeydown = function(evt)
		{
			var event = event||evt
			gameSelf.keyDownArray[	event.keyCode]=1
			gameSelf.keyUpArray[	event.keyCode]=0

			return false
		}
		document.onkeyup = function(evt)
		{
			var event = event||evt
			gameSelf.keyDownArray[	event.keyCode]=0
			gameSelf.keyUpArray[	event.keyCode]=1

			return false
		}


		this.angle	= {x:0,y:0,z:0,x255:0,y255:0,z255:0}
		this.camera = {x:0,y:0,z:-384}

		n = 11
/*
		this.camera.x = this.track.points[n].x
		this.camera.y = this.track.points[n].z+64
		this.camera.z = this.track.points[n].y
*/

		if( startAnimation )
			this.startAnimation()
	}


	/*
	 *	startAnimation
	 */
	this.startAnimation = function()
	{
		this.time = new Date();
		this.update()
	}


	/*
	 *	updateAnimation
	 */
	this.update = function()
	{
		//	clear canvas
		this.context2d.clearRect( 0, 0, this.canvas.width, this.canvas.height );

		// keyboard navigation
		if( this.keyUpArray[32] )
			this.navigationMode ^= 1
		if( this.navigationMode )
		{
			//	rotate
			this.angle.x255	+= 256+(this.keyDownArray[74]-this.keyDownArray[76])*4
			this.angle.y255	+= 256+(this.keyDownArray[73]-this.keyDownArray[75])*4
			this.angle.z255	+= 256+(this.keyDownArray[85]-this.keyDownArray[79])*4
		}
		else
		{
			//	pan
			this.camera.x	+= (this.keyDownArray[76]-this.keyDownArray[74])*8
			this.camera.y	+= (this.keyDownArray[73]-this.keyDownArray[75])*8
			this.camera.z	+= (this.keyDownArray[85]-this.keyDownArray[79])*8
		}

		this.angle.x255	&= 255
        this.angle.y255	&= 255
        this.angle.z255	&= 255
		this.angle.x	= this.angle.x255*Math.PI/128
		this.angle.y	= this.angle.y255*Math.PI/128
		this.angle.z	= this.angle.z255*Math.PI/128




/*
		var angle	= {x:this.time/1024,y:this.time/768,z:this.time/1536}
			camera	= {x:4*Math.cos(this.time/384*0),y:4*Math.cos(this.time/512),z:-32}

		var angle	= {x:0,y:0,z:0}
*/

		theModel = 'cube1'
		this.models[theModel].rotateProjectAndSort( this.angle, this.camera  )

		for( var i=0,p; p=this.models[theModel].faces[i]; i++ )
		{
			if( p.zr && p.zn>0 )
				this.models[theModel].drawTriangle( this.context2d, p )
		}



		// clear this.keyUpArray
		this.keyUpArray = []

		// timer
		var time = new Date();
		title = 'camera @ '+ this.camera.x +' , '+ this.camera.y +' , '+ this.camera.z +' | angle @ '+ this.angle.x255 +' , '+ this.angle.y255 +' , '+ this.angle.z255
		top.document.title = title +' | '+ Math.round( 1000/(time-this.time) )+' fps | '+ (this.navigationMode?'rotate':'pan')
		this.time = time;

		//	next update
		setTimeout( 'gameSelf.update()', 1 )
	}

}










var	n=64, f=n*1.5;
game.models.glenz = new Model()
game.models.glenz.vertices =
[
	{x: n,y: n,z: n},	{x:-n,y: n,z: n},	{x:-n,y:-n,z: n},	{x: n,y:-n,z: n},
	{x: n,y: n,z:-n},	{x:-n,y: n,z:-n},	{x:-n,y:-n,z:-n},	{x: n,y:-n,z:-n},
	{x: 0,y: 0,z: f},	{x: 0,y: 0,z:-f},	{x: 0,y: f,z: 0},	{x: 0,y:-f,z: 0},	{x: f,y: 0,z: 0},	{x:-f,y: 0,z: 0}
]
game.models.glenz.colors =
[
	'#69c', '#369', '#fff',
	'rgba(153,204,255,.5)', 'rgba(102,153,204,.5)', '#fff'
]
game.models.glenz.faces =
[
	{ color:0, a:0, b:1, c:8	},	{ color:0, a:2, b:3, c:8	},	{ color:1, a:1, b:2, c:8	},	{ color:1, a:3, b:0, c:8	},
	{ color:0, a:5, b:4, c:9	},	{ color:0, a:7, b:6, c:9	},	{ color:1, a:6, b:5, c:9	},	{ color:1, a:4, b:7, c:9	},
	{ color:0, a:0, b:3, c:12	},	{ color:0, a:7, b:4, c:12	},	{ color:1, a:4, b:0, c:12	},	{ color:1, a:3, b:7, c:12	},
	{ color:0, a:2, b:1, c:13	},	{ color:0, a:5, b:6, c:13	},	{ color:1, a:1, b:5, c:13	},	{ color:1, a:6, b:2, c:13	},
	{ color:1, a:1, b:0, c:10	},	{ color:1, a:4, b:5, c:10	},	{ color:0, a:5, b:1, c:10	},	{ color:0, a:0, b:4, c:10	},
	{ color:1, a:3, b:2, c:11	},	{ color:1, a:6, b:7, c:11	},	{ color:0, a:2, b:6, c:11	},	{ color:0, a:7, b:3, c:11	}
]






var scale = 1/3.0
onload=function()
{

	//	create track curve
/*
	n=48
	game.track.controlPoints = []
	for( var i=0;i<n; i++ )
	{
		var an= 2*Math.PI*i/n
		game.track.controlPoints.push(
		{
			x:512*Math.cos( an+Math.random()*Math.PI/2 )+(Math.random()*512-256),
			y:512*Math.sin( an+Math.random()*Math.PI/2 )+(Math.random()*512-256),
			z:64+Math.random()*256
		})
	}
	game.track.controlPoints[0].z = game.track.controlPoints[n-1].z
	game.track.evaluateCurve( 2 )


	//	create track model
	game.createTrackModel();

	document.body.innerHTML += '<p>The race track is a Bezier curve made of :<br/>'+ game.track.controlPoints.length +' controls points subdivided '+ game.track.weightSubdivisions +' times &rarr; '+ game.track.points.length +' points <br/>'
							+ game.models.track.vertices.length +' vertices &rarr; '+ game.models.track.faces.length +' faces </p>'

*/

	if( 0 )
	for( i=0,p; p=game.track.controlPoints[i]; i++ )
	{
		var tag = document.createElement('div')
		tag.style = 'left:'+ Math.round(256+p.x*scale) +'px;bottom:'+ Math.round(256+p.y*scale) +'px;z-index:65537;font-weight:bold;'
		tag.style.backgroundColor = tag.style.color = '#f60'
		tag.appendChild( document.createTextNode( i ))
		document.body.appendChild( tag )
	}


	game.models['cube1'] = new Cube( 64,0,0,0 )
	game.models['cube1'].colors.push( '#f00', '#c00', '#0f0', '#0c0', '#00f', '#00c' )


	game.initialize( true )
}


/*
function m3x3M( m1 ,m2 )
{
	// Multiply two 3x3 matrices and return the product matrix
	return	[
		m1[0]*m2[0] +m1[1]*m2[3] +m1[2]*m2[6],
		m1[0]*m2[1] +m1[1]*m2[4] +m1[2]*m2[7],
		m1[0]*m2[2] +m1[1]*m2[5] +m1[2]*m2[8],

		m1[3]*m2[0] +m1[4]*m2[3] +m1[4]*m2[6],
		m1[3]*m2[1] +m1[4]*m2[4] +m1[4]*m2[7],
		m1[3]*m2[2] +m1[4]*m2[5] +m1[4]*m2[8],

		m1[6]*m2[0] +m1[7]*m2[3] +m1[8]*m2[6],
		m1[6]*m2[1] +m1[7]*m2[4] +m1[8]*m2[7],
		m1[6]*m2[2] +m1[7]*m2[5] +m1[8]*m2[8]
	]
}

function mV3x3M(v,m){
	// Multiply a vector with a 3x3 matrix and return the product vector
	return	[v[0]*m[0]+v[1]*m[1]+v[2]*m[2], v[0]*m[3]+v[1]*m[4]+v[2]*m[4], v[0]*m[6]+v[1]*m[7]+v[2]*m[8]]
}


*/
